//Removing Preloader
setTimeout(function(){
    var preloader = document.getElementById('preloader')
    if(preloader){preloader.classList.add('preloader-hide');}
},150);

document.addEventListener('DOMContentLoaded', () => {
    'use strict'
    
    //Image Sliders
        var splide = document.getElementsByClassName('splide');
        if(splide.length){            
            var singleSlider = document.querySelectorAll('.single-slider');
            if(singleSlider.length){
                singleSlider.forEach(function(e){
                    var single = new Splide( '#'+e.id, {
                        type:'loop',
                        autoplay:true,
                        interval:4000,
                        perPage: 1,
                    }).mount();
                    var sliderNext = document.querySelectorAll('.slider-next');
                    var sliderPrev = document.querySelectorAll('.slider-prev'); 
                    sliderNext.forEach(el => el.addEventListener('click', el => {single.go('>');}));
                    sliderPrev.forEach(el => el.addEventListener('click', el => {single.go('<');}));
                });
            }
            
            var doubleSlider = document.querySelectorAll('.double-slider');
            if(doubleSlider.length){
                doubleSlider.forEach(function(e){
                     var double = new Splide( '#'+e.id, {
                        type:'loop',
                        autoplay:true,
                        interval:4000,
                        arrows:false,
                        perPage: 2,
                    }).mount();
                });
            }
            
            var trippleSlider = document.querySelectorAll('.tripple-slider');
            if(trippleSlider.length){
                trippleSlider.forEach(function(e){
                     var tripple = new Splide( '#'+e.id, {
                        type:'loop',
                        autoplay:true,
                        padding: {
                            left   :'0px',
                            right: '80px',
                        },
                        interval:4000,
                        arrows:false,
                        perPage: 2,
                        perMove: 1,
                    }).mount();
                });
            }
        }


        var footerBar = document.querySelectorAll('.footer-bar-5')[0];
        if(footerBar){
            var footerBar_select = document.querySelectorAll('#footer-bar .active-nav')[0];
            footerBar_select.insertAdjacentHTML('beforeend', '<strong></strong>');
        }
        
        //Detect Ad Block
        
        var adblockMessage = document.getElementById('adblock-message')
        if(adblockMessage){
            var adblockEnabled = false;
            document.body.innerHTML += '<div class="adsbygoogle" id="ad-detector"></div>';
            var adElement = document.getElementById('ad-detector');
            var adElementStyle = getComputedStyle(adElement, null);
            if(adElementStyle.display === 'none') {document.getElementById('adblock-message').classList.remove('disabled');} 
        }

        //Card Extender
        const cards = document.getElementsByClassName('card');
        function card_extender(){
            var headerHeight, footerHeight, headerOnPage;
            var headerOnPage = document.querySelectorAll('.header:not(.header-transparent)')[0];
            var footerOnPage = document.querySelectorAll('#footer-bar')[0];
            
            headerOnPage ? headerHeight = document.querySelectorAll('.header')[0].offsetHeight : headerHeight = 0
            footerOnPage ? footerHeight = document.querySelectorAll('#footer-bar')[0].offsetHeight : footerHeight = 0
            
            for (let i = 0; i < cards.length; i++) {
                if(cards[i].getAttribute('data-card-height') === "cover"){
                    if (window.matchMedia('(display-mode: fullscreen)').matches) {var windowHeight = window.outerHeight;}
                    if (!window.matchMedia('(display-mode: fullscreen)').matches) {var windowHeight = window.innerHeight;}
                    var coverHeight = windowHeight - headerHeight - footerHeight + 'px';
                }
                if(cards[i].getAttribute('data-card-height') === "cover-card"){
                    var windowHeight = window.outerHeight;
                    var coverHeight = windowHeight - 275 + 'px';
                    cards[i].style.height =  coverHeight
                }
                if(cards[i].getAttribute('data-card-height') === "cover-full"){
                    if (window.matchMedia('(display-mode: fullscreen)').matches) {var windowHeight = window.outerHeight;}
                    if (!window.matchMedia('(display-mode: fullscreen)').matches) {var windowHeight = window.innerHeight;}
                    var coverHeight = windowHeight + 'px';
                    cards[i].style.height =  coverHeight
                }
                if(cards[i].hasAttribute('data-card-height')){
                    var getHeight = cards[i].getAttribute('data-card-height');
                    cards[i].style.height= getHeight +'px';
                    if(getHeight === "cover"){
                        var totalHeight = getHeight
                        cards[i].style.height =  coverHeight
                    }
                }
            }
        }
        
        if(cards.length){
            card_extender();
            window.addEventListener("resize", card_extender);
        }  

                //Validator
        var inputField = document.querySelectorAll('input');
        if(inputField.length){      
            var mailValidator = /^[A-Z0-9._%+-]+@([A-Z0-9-]+\.)+[A-Z]{2,4}$/i;
            var phoneValidator = /^[(]{0,1}[0-9]{3}[)]{0,1}[-\s\.]{0,1}[0-9]{3}[-\s\.]{0,1}[0-9]{4}$/;
            var nameValidator = /^[a-zA-ZàáâäãåąčćęèéêëėįìíîïłńòóôöõøùúûüųūÿýżźñçčšžÀÁÂÄÃÅĄĆČĖĘÈÉÊËÌÍÎÏĮŁŃÒÓÔÖÕØÙÚÛÜŲŪŸÝŻŹÑßÇŒÆČŠŽ∂ð ,.'-]+$/u;
            var passwordValidator = /[A-Za-z]{2}[A-Za-z]*[ ]?[A-Za-z]*/;
            var numberValidator = /^(0|[1-9]\d*)$/;
            var linkValidator = /^(http|https)?:\/\/[a-zA-Z0-9-\.]+\.[a-z]{2,4}/;
            var textValidator = /[A-Za-z]{2}[A-Za-z]*[ ]?[A-Za-z]*/;

            function valid(el){
                el.parentElement.querySelectorAll('.valid')[0].classList.remove('disabled'); 
                el.parentElement.querySelectorAll('.invalid')[0].classList.add('disabled');
            }
            function invalid(el){
                el.parentElement.querySelectorAll('.valid')[0].classList.add('disabled');
                el.parentElement.querySelectorAll('.invalid')[0].classList.remove('disabled');
            }
            function unfilled(el){
                el.parentElement.querySelectorAll('em')[0].classList.remove('disabled');
                el.parentElement.querySelectorAll('.valid')[0].classList.add('disabled');
                el.parentElement.querySelectorAll('.invalid')[0].classList.add('disabled');
            }
            
            var regularField = document.querySelectorAll('.input-style input:not([type="date"])')
            regularField.forEach(el => el.addEventListener('keyup', e => {
                if(!el.value == ""){
                    el.parentElement.classList.add('input-style-active');
                    el.parentElement.querySelector('em').classList.add('disabled');
                } else {
                    el.parentElement.querySelectorAll('.valid')[0].classList.add('disabled');
                    el.parentElement.querySelectorAll('.invalid')[0].classList.add('disabled');
                    el.parentElement.classList.remove('input-style-active');
                    el.parentElement.querySelector('em').classList.remove('disabled');
                }
            }));   
            
            var regularTextarea = document.querySelectorAll('.input-style textarea')
            regularTextarea.forEach(el => el.addEventListener('keyup', e => {
                if(!el.value == ""){
                    el.parentElement.classList.add('input-style-active');
                    el.parentElement.querySelector('em').classList.add('disabled');
                } else {
                    el.parentElement.classList.remove('input-style-active');
                    el.parentElement.querySelector('em').classList.remove('disabled');
                }
            }));
            
            var selectField = document.querySelectorAll('.input-style select')
            selectField.forEach(el => el.addEventListener('change', e => {
                if(el.value !== "default"){
                    el.parentElement.classList.add('input-style-active');
                    el.parentElement.querySelectorAll('.valid')[0].classList.remove('disabled');
                    el.parentElement.querySelectorAll('.invalid, em, span')[0].classList.add('disabled');
                }  
                if(el.value == "default"){
                    el.parentElement.querySelectorAll('span, .valid, em')[0].classList.add('disabled');
                    el.parentElement.querySelectorAll('.invalid')[0].classList.remove('disabled');
                    el.parentElement.classList.add('input-style-active');
                }
            }));
            
            var dateField = document.querySelectorAll('.input-style input[type="date"]')
            dateField.forEach(el => el.addEventListener('change', e => {
                el.parentElement.classList.add('input-style-active');
                el.parentElement.querySelectorAll('.valid')[0].classList.remove('disabled');
                el.parentElement.querySelectorAll('.invalid')[0].classList.add('disabled');
            }));
            
            var validateField = document.querySelectorAll('.validate-field input, .validator-field textarea');
            if(validateField.length){
                validateField.forEach(el => el.addEventListener('keyup', e => {
                    var getAttribute = el.getAttribute('type');
                    switch(getAttribute){
                        case 'name': nameValidator.test(el.value) ? valid(el) : invalid(el); break;
                        case 'number': numberValidator.test(el.value) ? valid(el) : invalid(el); break;
                        case 'email': mailValidator.test(el.value) ? valid(el) : invalid(el); break;
                        case 'text': textValidator.test(el.value) ? valid(el) : invalid(el); break;
                        case 'url': linkValidator.test(el.value) ? valid(el) : invalid(el); break;
                        case 'tel': phoneValidator.test(el.value) ? valid(el) : invalid(el); break;
                        case 'password': passwordValidator.test(el.value) ? valid(el) : invalid(el); break;
                    }
                    if(el.value === ""){unfilled(el);}
                }));
            }
        }

        //Opening Menus
                var menuOpen = document.querySelectorAll('[data-menu]');
                var wrappers = document.querySelectorAll('.header, #footer-bar, .page-content');

                menuOpen.forEach(el => el.addEventListener('click',e =>{
                    //Close Existing Opened Menus 
                    const activeMenu = document.querySelectorAll('.menu-active');
                    for(let i=0; i < activeMenu.length; i++){activeMenu[i].classList.remove('menu-active');}
                    //Open Clicked Menu
                    var menuData = el.getAttribute('data-menu');
                    document.getElementById(menuData).classList.add('menu-active');
                    document.getElementsByClassName('menu-hider')[0].classList.add('menu-active');    
                    //Check and Apply Effects
                    var menu = document.getElementById(menuData);
                    var menuEffect = menu.getAttribute('data-menu-effect');
                    var menuLeft = menu.classList.contains('menu-box-left');
                    var menuRight = menu.classList.contains('menu-box-right');
                    var menuTop = menu.classList.contains('menu-box-top');
                    var menuBottom = menu.classList.contains('menu-box-bottom');
                    var menuWidth = menu.offsetWidth;
                    var menuHeight = menu.offsetHeight;
                    var menuTimeout = menu.getAttribute('data-menu-hide');
                    
                    if(menuTimeout){
                        setTimeout(function(){
                            document.getElementById(menuData).classList.remove('menu-active');
                            document.getElementsByClassName('menu-hider')[0].classList.remove('menu-active');    
                        },menuTimeout)
                    }

                    if(menuEffect === "menu-push"){
                        var menuWidth = document.getElementById(menuData).getAttribute('data-menu-width');
                        if(menuLeft){for(let i=0; i < wrappers.length; i++){wrappers[i].style.transform = "translateX("+menuWidth+"px)"}}
                        if(menuRight){for(let i=0; i < wrappers.length; i++){wrappers[i].style.transform = "translateX(-"+menuWidth+"px)"}}
                        if(menuBottom){for(let i=0; i < wrappers.length; i++){wrappers[i].style.transform = "translateY(-"+menuHeight+"px)"}}
                        if(menuTop){for(let i=0; i < wrappers.length; i++){wrappers[i].style.transform = "translateY("+menuHeight+"px)"}}
                    }
                    if(menuEffect === "menu-parallax"){
                        var menuWidth = document.getElementById(menuData).getAttribute('data-menu-width');
                        if(menuLeft){for(let i=0; i < wrappers.length; i++){wrappers[i].style.transform = "translateX("+menuWidth/10+"px)"}}
                        if(menuRight){for(let i=0; i < wrappers.length; i++){wrappers[i].style.transform = "translateX(-"+menuWidth/10+"px)"}}
                        if(menuBottom){for(let i=0; i < wrappers.length; i++){wrappers[i].style.transform = "translateY(-"+menuHeight/5+"px)"}}
                        if(menuTop){for(let i=0; i < wrappers.length; i++){wrappers[i].style.transform = "translateY("+menuHeight/5+"px)"}}
                    }
                }));




     //Greetig Heading
        var pageTitle = document.querySelectorAll('.page-title-large, .page-title-small, .menu-header a');
        if(pageTitle){
            var greetingTime = new Date().getHours();
            var greetingMessage;
            var greetingExist = document.querySelectorAll('.greeting-text')[0]
            if(greetingExist){
            var greetingUser = document.querySelectorAll('.greeting-text')[0].getAttribute('data-username');
                var greetingMorning = ('Good morning');
                var greetingAfternoon = ('Good afternoon');
                var greetingEvening = ('Good evening');

                if (greetingTime >= 0 && greetingTime < 12) {greetingMessage = greetingMorning; 
                } else if (greetingTime >= 12 && greetingTime < 17) {greetingMessage = greetingAfternoon;
                } else if (greetingTime >= 17 && greetingTime < 24) {greetingMessage = greetingEvening;}
                document.querySelectorAll('.greeting-text')[0].insertAdjacentHTML('beforeend', greetingMessage + ',<br>' +greetingUser);       
            }
        }

        

});

